## 安装包下载
[http://nginx.org/en/download.html](http://nginx.org/en/download.html)

- **安装Nginx**
1. 安装依赖：
> [root@VM-12-6-centos software]# yum -y install gcc zlib zlib-devel pcre pcre-devel openssl openssl-devel make


2. 解压安装包并切换到文件夹中：
> [root@VM-12-6-centos software]# tar -zxvf /opt/software/nginx-1.22.0.tar.gz
> [root@VM-12-6-centos software]# cd nginx-1.22.0

3. 开始执行编译、安装(一并安装SSL模块)：
> [root@VM-12-6-centos nginx-1.22.0]# ./configure --prefix=/usr/local/nginx --with-http_stub_status_module --with-http_ssl_module
> [root@VM-12-6-centos nginx-1.22.0]# make && make install

4. 查看是否安装成功
> [root@VM-12-6-centos nginx-1.22.0]# /usr/local/nginx/sbin
> [root@VM-12-6-centos nginx-1.22.0]# ./nginx -V

显示如下：
> nginx version: nginx/1.22.0
> built by gcc 4.8.5 20150623 (Red Hat 4.8.5-44) (GCC) 
> built with OpenSSL 1.0.2k-fips  26 Jan 2017
> TLS SNI support enabled
> configure arguments: --prefix=/usr/local/nginx --with-http_stub_status_module --with-http_ssl_module

安装结束。

- **配置环境变量**
1. 查看 nginx 版本，此时会发现报 bash:nginx: 未找到命令，需要我们手动配置打开环境变量的文件
> [root@VM-12-6-centos nginx-1.22.0]# nginx -v

显示如下：
> bash: nginx: command not found...

2. 编辑环境变量文件：
> [root@VM-12-6-centos nginx-1.22.0]# vim /etc/profile

行末加上自己的nginx安装目录下sbin目录的地址：
```shell
.... #前面省略
export PATH=$PATH:/usr/local/nginx/sbin
```

3. 重新加载环境：
> [root@VM-12-6-centos nginx-1.22.0]# source /etc/profile

4. 再次查看 nginx 版本
> [root@iZuf68wpeyqmolhdab3bh0Z software]# nginx -v

显示如下：
> nginx version: nginx/nginx-1.22.0


- **开机启动配置**
1. 先创建开机自启脚本：
> [root@VM-12-6-centos software]# cd /etc/systemd/system
> [root@VM-12-6-centos system]# vim nginx.service

2. 内容复制到 vim 中：
```shell
[Unit]
Description=nginx service
After=network.target

[Service]
Type=forking
ExecStart=/usr/local/nginx/sbin/nginx
ExecReload=/usr/local/nginx/sbin/nginx -s reload
ExecStop=/usr/local/nginx/sbin/nginx -s quit
PrivateTmp=true

[Install]
WantedBy=multi-user.target
```

3. 服务命令：
> **第一种方式启动**
> **#启动nginx服务**
> cd /usr/local/nginx/sbin/
> ./nginx
> **#查看运行状态**
> ps aux | grep nginx
> **#停止nginx服务**
> ./nginx –s stop
> **#重启nginx服务**
> ./nginx –s reload
> **#检查配置文件是否正确**
> ./nginx –t
> **#查看nginx版本**
> ./nginx –v
> 
> **第二种基于配置开机启动模式启动**
> **#设置开机自启动**
> systemctl enable nginx
> **#启动nginx服务**
> systemctl start nginx.service
> **#重新启动服务**
> systemctl restart nginx.service
> **#查看服务当前状态**
> systemctl status nginx.service
> **#停止开机自启动**
> systemctl disable nginx.service


4. 访问服务器IP

显示welcom to nginx 说明启动安装成功了，接下来可以通过编辑nginx.conf文件来进行项目的部署了。建议备份一下配置文件。

- **配置HTTPS**

证书可以自行到阿里云或者腾讯云申请免费的证书，并下载对应Nginx的证书
服务器 /usr/local/nginx/conf 下创建 cert 目录，并将证书放入该文件夹中
编辑Nginx配置文件：
> [root@VM-12-6-centos software]#  cd /usr/local/nginx/conf
> [root@VM-12-6-centos conf]#  vim nginx.conf

在http代码块里添加如下配置：
```shell
server {
    listen 80;
    server_name xxx.com; #你的域名
    rewrite ^(.*)$ https://$host$1 permanent; #把http的域名请求转成https
}

server {
 listen 443;
 server_name xxx.com;
 ssl on;
 ssl_certificate   cert/xxxxxxxxxxxxxxx.pem; #证书文件路径
 ssl_certificate_key  cert/xxxxxxxxxxxxxxx.key; #证书文件路径
 ssl_session_timeout 5m;
 ssl_ciphers ECDHE-RSA-AES128-GCM-SHA256:ECDHE:ECDH:AES:HIGH:!NULL:!aNULL:!MD5:!!
ADH:!RC4;
 ssl_protocols TLSv1 TLSv1.1 TLSv1.2;
 ssl_prefer_server_ciphers on;

 #配置根路径（根据自身需求进行配置）
 location / {
     proxy_pass http://127.0.0.1:8080;
 }

 #配置后台业务路径（根据自身需求进行配置）
 location /portal {
     alias /usr/local/app/webapps/portal/;
     index index.html index.htm;
 }
}
```

- **常用配置**
```shell
nginx对上传文件大小有要求，默认1m，如果很大，还要适当调整上传超时时间。

1. client_max_body_size

限制请求体的大小，若超过所设定的大小，返回413错误。

client_header_timeout
读取请求头的超时时间，若超过所设定的大小，返回408错误。

3. client_body_timeout

读取请求实体的超时时间，若超过所设定的大小，返回413错误。

proxy_connect_timeout
http请求无法立即被容器(tomcat, netty等)处理，被放在nginx的待处理池中等待被处理。此参数为等待的最长时间，默认为60秒，官方推荐最长不要超过75秒。

proxy_read_timeout
http请求被容器(tomcat, netty等)处理后，nginx会等待处理结果，也就是容器返回的response。此参数即为服务器响应时间，默认60秒。

proxy_send_timeout
http请求被服务器处理完后，把数据传返回给Nginx的用时，默认60秒。
```
